// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

/**
 * @title IStakingAccountant
 * @notice Interface for the Kinetiq StakingAccountant contract
 * @dev This is a simplified interface for integration purposes.
 *      For the full interface, see src/interfaces/IStakingAccountant.sol
 */
interface IStakingAccountant {
    /* ========== VIEW FUNCTIONS ========== */

    /// @notice Gets the total amount of HYPE staked across all managers
    function totalStaked() external view returns (uint256);

    /// @notice Gets the total amount of HYPE claimed
    function totalClaimed() external view returns (uint256);

    /// @notice Gets total rewards accrued
    function totalRewards() external view returns (uint256);

    /// @notice Gets total slashing losses
    function totalSlashing() external view returns (uint256);

    /**
     * @notice Convert kHYPE amount to HYPE using current exchange rate
     * @param kHYPEAmount Amount of kHYPE to convert
     * @return Equivalent HYPE amount
     */
    function kHYPEToHYPE(uint256 kHYPEAmount) external view returns (uint256);

    /**
     * @notice Convert HYPE amount to kHYPE using current exchange rate
     * @param HYPEAmount Amount of HYPE to convert
     * @return Equivalent kHYPE amount
     */
    function HYPEToKHYPE(uint256 HYPEAmount) external view returns (uint256);
}

